<?php
/*
Plugin Name: Digital Onion Follow Menu
Author: Awaji_Tamao
Version: 7.1
*/

if (!defined('ABSPATH')) exit;

// 管理画面設定の登録
add_action('admin_init', function() {
    $settings = ['do_menu_label', 'do_menu_pos', 'do_btn_color', 'do_bg_color', 'do_txt_color', 'do_font_family', 'do_font_size', 'do_opacity'];
    foreach($settings as $s) register_setting('do-menu-group', $s);
});

// 設定メニューの追加
add_action('admin_menu', function() {
    add_options_page('DO Menu設定', 'DO Menu設定', 'manage_options', 'do-menu-settings', 'do_menu_settings_page');
});

function do_menu_settings_page() {
    ?>
    <div class="wrap">
        <h1>Digital Onion Follow Menu 設定</h1>
        <form method="post" action="options.php">
            <?php settings_fields('do-menu-group'); ?>
            <table class="form-table">
                <tr><th>表示名</th><td><input type="text" name="do_menu_label" value="<?php echo esc_attr(get_option('do_menu_label', 'MENU')); ?>"></td></tr>
                <tr><th>設置位置</th><td>
                    <select name="do_menu_pos">
                        <option value="top" <?php selected(get_option('do_menu_pos'), 'top'); ?>>上</option>
                        <option value="center" <?php selected(get_option('do_menu_pos'), 'center'); ?>>中央</option>
                        <option value="bottom" <?php selected(get_option('do_menu_pos'), 'bottom'); ?>>下</option>
                    </select>
                </td></tr>
                <tr><th>背景透明度 (0-100)</th><td><input type="number" name="do_opacity" min="0" max="100" value="<?php echo esc_attr(get_option('do_opacity', '80')); ?>"> %</td></tr>
                <tr><th>ボタン背景色</th><td><input type="text" name="do_btn_color" class="color-field" value="<?php echo esc_attr(get_option('do_btn_color', '#ff5722')); ?>"></td></tr>
                <tr><th>展開背景色</th><td><input type="text" name="do_bg_color" class="color-field" value="<?php echo esc_attr(get_option('do_bg_color', '#1a1a1a')); ?>"></td></tr>
                <tr><th>文字色</th><td><input type="text" name="do_txt_color" class="color-field" value="<?php echo esc_attr(get_option('do_txt_color', '#ffffff')); ?>"></td></tr>
                <tr><th>フォント</th><td><input type="text" name="do_font_family" value="<?php echo esc_attr(get_option('do_font_family', 'sans-serif')); ?>"></td></tr>
                <tr><th>文字サイズ(px)</th><td><input type="number" name="do_font_size" value="<?php echo esc_attr(get_option('do_font_size', '14')); ?>"></td></tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

// スクリプトとCSSの登録
add_action('admin_enqueue_scripts', function($hook) {
    if ('settings_page_do-menu-settings' !== $hook) return;
    wp_enqueue_style('wp-color-picker');
    wp_enqueue_script('do-admin-js', plugins_url('admin.js', __FILE__), array('wp-color-picker', 'jquery'), null, true);
});

add_action('wp_enqueue_scripts', function() {
    wp_enqueue_style('do-style', plugins_url('style.css', __FILE__));
    wp_add_inline_style('do-style', do_generate_dynamic_css());
    wp_enqueue_script('do-script', plugins_url('script.js', __FILE__), [], null, true);
});

function do_hex_to_rgba($hex, $opacity) {
    $hex = str_replace("#", "", $hex);
    if(strlen($hex) == 3) {
        $r = hexdec(substr($hex,0,1).substr($hex,0,1));
        $g = hexdec(substr($hex,1,1).substr($hex,1,1));
        $b = hexdec(substr($hex,2,1).substr($hex,2,1));
    } else {
        $r = hexdec(substr($hex,0,2));
        $g = hexdec(substr($hex,2,2));
        $b = hexdec(substr($hex,4,2));
    }
    return "rgba($r, $g, $b, $opacity)";
}

function do_generate_dynamic_css() {
    $pos = get_option('do_menu_pos', 'center');
    $opacity = (int)get_option('do_opacity', 80) / 100;
    $btn_rgba = do_hex_to_rgba(get_option('do_btn_color', '#ff5722'), $opacity);
    $bg_rgba = do_hex_to_rgba(get_option('do_bg_color', '#1a1a1a'), $opacity);
    $txt_color = esc_attr(get_option('do_txt_color', '#ffffff'));

    $layout_css = "";
    if ($pos === 'top') {
        $layout_css = "top: 20px; bottom: auto; transform: none;";
    } elseif ($pos === 'bottom') {
        $layout_css = "top: auto; bottom: 20px; transform: none;";
    } else {
        $layout_css = "top: 50%; bottom: auto; transform: translateY(-50%);";
    }

    return "
    #do-follow-container { $layout_css font-family: ".esc_attr(get_option('do_font_family', 'sans-serif'))."; }
    .do-label { background: $btn_rgba !important; color: $txt_color; font-size: ".esc_attr(get_option('do_font_size', '14'))."px; }
    #do-follow-container nav, #do-follow-container .sub-menu { background: $bg_rgba !important; }
    #do-follow-container a { color: $txt_color; font-size: ".esc_attr(get_option('do_font_size', '14'))."px; }";
}

add_action('init', function() { register_nav_menu('do-follow-menu', 'Digital Onion Follow Menu'); });

add_action('wp_footer', function() {
    if (has_nav_menu('do-follow-menu')) {
        echo '<div id="do-follow-container"><div class="do-label">'.esc_html(get_option('do_menu_label', 'MENU')).'</div>';
        wp_nav_menu(['theme_location' => 'do-follow-menu', 'container' => 'nav', 'depth' => 2]);
        echo '</div>';
    }
});