(function() {
    let lastScrollY = window.scrollY;
    let ticking = false;
    let touchStartX = 0;

    const container = document.getElementById('do-follow-container');
    if (!container) return;

    // --- PC用：マウスホバーで開閉 ---
    container.addEventListener('mouseenter', () => {
        if (window.innerWidth > 768) { 
            container.classList.add('do-active');
        }
    });

    container.addEventListener('mouseleave', () => {
        if (window.innerWidth > 768) { 
            container.classList.remove('do-active');
        }
    });

    // --- スマホ用：ラベルタップで開閉 ---
    const label = container.querySelector('.do-label');
    if (label) {
        label.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            container.classList.toggle('do-active');
        });
    }

    // --- スマホ用：右スワイプで閉じる ---
    container.addEventListener('touchstart', (e) => {
        touchStartX = e.changedTouches[0].screenX;
    }, { passive: true });

    container.addEventListener('touchend', (e) => {
        let touchEndX = e.changedTouches[0].screenX;
        // メニューが開いている時、右へ40px以上スワイプで閉じる
        if (touchEndX > touchStartX + 40 && container.classList.contains('do-active')) {
            container.classList.remove('do-active');
        }
    }, { passive: true });

    // --- スクロール戻り（先頭に戻る）を徹底防止 ---
    const allLinks = container.querySelectorAll('a');
    allLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            const href = this.getAttribute('href');
            if (!href || href === '#' || href === '') {
                e.preventDefault();
            }
            if (href && href !== '#' && !this.parentNode.classList.contains('menu-item-has-children')) {
                container.classList.remove('do-active');
            }
        });
    });

    // --- スクロール追従（ヌルッと戻る調整） ---
    window.addEventListener('scroll', () => {
        if (!ticking) {
            window.requestAnimationFrame(() => {
                const currentScrollY = window.scrollY;
                const diff = currentScrollY - lastScrollY;
                
                let move = diff * -0.7;
                if (move > 60) move = 60;
                if (move < -60) move = -60;
                
                // スクロール中は即時反映
                container.style.transition = "margin-top 0.1s linear, right 0.5s ease";
                container.style.marginTop = move + "px";
                
                clearTimeout(window.doTimeout);
                window.doTimeout = setTimeout(() => {
                    // スクロール停止後、0.8秒かけてゆーっくり定位置に戻る
                    container.style.transition = "margin-top 0.8s cubic-bezier(0.23, 1, 0.32, 1), right 0.5s ease";
                    container.style.marginTop = "0px";
                }, 150); 
                
                lastScrollY = currentScrollY;
                ticking = false;
            });
            ticking = true;
        }
    }, { passive: true });
})();