( function( blocks, element, blockEditor, components ) {
    var el = element.createElement;
    var InnerBlocks = blockEditor.InnerBlocks;
    var useBlockProps = blockEditor.useBlockProps;
    var InspectorControls = blockEditor.InspectorControls;
    var TextControl = components.TextControl;
    var PanelBody = components.PanelBody;

    blocks.registerBlockType( 'ainas-card-blocks/card-button', {
        title: 'カードボタン',
        icon: 'format-image',
        category: 'design',

        edit: function( props ) {
            var attributes = props.attributes;
            return el(
                'div',
                useBlockProps( { className: 'ainas-card-admin' } ),
                el( InspectorControls, {},
                    el( PanelBody, { title: 'リンク設定' },
                        el( TextControl, {
                            label: 'リンク先URL',
                            value: attributes.url,
                            onChange: function( val ) {
                                props.setAttributes( { url: val } );
                            },
                        } )
                    )
                ),
                el( 'div', { className: 'card-content' },
                    el( InnerBlocks )
                ),
                attributes.url ? el('small', {style: {display: 'block', marginTop: '5px', color: '#666'}}, 'リンク先: ' + attributes.url) : el('small', {style: {color: 'red'}}, '※URL未設定（リンクなし）')
            );
        },

        save: function( props ) {
            var attributes = props.attributes;
            var hasUrl = attributes.url && attributes.url.trim() !== '';
            var baseClass = 'wp-block-ainas-card-blocks-card-button';
            
            if ( hasUrl ) {
                // URLがある場合：aタグを出力
                return el(
                    'a',
                    useBlockProps.save( { 
                        className: baseClass,
                        href: attributes.url 
                    } ),
                    el( 'div', { className: 'card-content' },
                        el( InnerBlocks.Content )
                    )
                );
            } else {
                // URLがない場合：divタグを出力
                return el(
                    'div',
                    useBlockProps.save( { 
                        className: baseClass + ' no-link' 
                    } ),
                    el( 'div', { className: 'card-content' },
                        el( InnerBlocks.Content )
                    )
                );
            }
        },
    } );
}(
    window.wp.blocks,
    window.wp.element,
    window.wp.blockEditor,
    window.wp.components
) );