<?php
/**
 * Plugin Name: digitalonion_card_blocks
 * Author: Awaji_Tamao
 * Description: 自由に配置可能なリンク付きカードブロック（ビルド不要版）。
 * Version: 1.1.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

function ainas_card_blocks_register() {
    // スクリプトの登録
    wp_register_script(
        'ainas-card-block-js',
        plugins_url( 'block.js', __FILE__ ),
        array( 'wp-blocks', 'wp-element', 'wp-block-editor', 'wp-components' )
    );

    // スタイルの登録
    wp_register_style(
        'ainas-card-block-css',
        plugins_url( 'style.css', __FILE__ )
    );

    // ブロックの登録
    register_block_type( 'ainas-card-blocks/card-button', array(
        'editor_script' => 'ainas-card-block-js',
        'style'         => 'ainas-card-block-css',
        'attributes'    => array(
            'url' => array( 'type' => 'string', 'default' => '' ),
        ),
    ) );
}
add_action( 'init', 'ainas_card_blocks_register' );