<?php
/*
Plugin Name: DigitalOnion_photo_slider
Description: スマホのタッチ・スワイプ操作に完全対応。タブ切り替え、複数画像一括選択、ドラッグ＆ドロップ並び替え機能付き。
Version: 1.0
Author: AwajiTamao
*/

if (!defined('ABSPATH')) exit;

/**
 * 1. 管理画面メニュー登録
 */
add_action('admin_menu', function() {
    add_options_page('DigitalOnion_photo_slider', 'DigitalOnion_Slider', 'manage_options', 'aps_settings', 'aps_render_settings');
});

/**
 * 2. 管理画面に必要なスクリプト・スタイルの読み込み
 */
add_action('admin_enqueue_scripts', function($hook) {
    if (strpos($hook, 'aps_settings') !== false) {
        wp_enqueue_media();
        wp_enqueue_script('jquery-ui-sortable');
    }
});

/**
 * 3. 設定画面のレンダリング
 */
function aps_render_settings() {
    if (isset($_POST['aps_save'])) {
        update_option('aps_height', $_POST['aps_height']);
        update_option('aps_speed', $_POST['aps_speed']);
        $all_sliders = array();
        for ($s=1; $s<=5; $s++) {
            $imgs = isset($_POST["slider_{$s}_imgs"]) ? array_filter($_POST["slider_{$s}_imgs"]) : array();
            $all_sliders[$s] = array_values($imgs);
        }
        update_option('aps_sliders_data', $all_sliders);
        echo '<div class="updated"><p>設定を保存しました。</p></div>';
    }

    $h = get_option('aps_height', '300');
    $s_val = get_option('aps_speed', '40');
    $all_data = get_option('aps_sliders_data', []);
    ?>
    <style>
        .aps-admin-container { max-width: 1000px; margin-top: 20px; font-family: sans-serif; }
        .aps-tabs-nav { display: flex; border-bottom: 2px solid #2271b1; margin: 20px 0 0 0; padding: 0; list-style: none; }
        .aps-tab-link { padding: 10px 20px; background: #dcdcde; border: 1px solid #ccc; border-bottom: none; cursor: pointer; margin-right: 4px; border-radius: 4px 4px 0 0; transition: 0.2s; }
        .aps-tab-link.active { background: #2271b1; color: #fff; border-color: #2271b1; font-weight: bold; }
        .aps-tab-content { display: none; background: #fff; border: 1px solid #ccc; padding: 25px; border-top: none; }
        .aps-tab-content.active { display: block; }
        .aps-gallery-list { display: grid; grid-template-columns: repeat(auto-fill, minmax(140px, 1fr)); gap: 15px; margin-top: 20px; min-height: 100px; background: #f6f7f7; padding: 15px; border: 2px dashed #dcdcde; border-radius: 4px; }
        .aps-gallery-item { position: relative; width: 140px; height: 140px; border: 1px solid #dcdcde; background: #fff; cursor: move; border-radius: 4px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        .aps-gallery-item img { width: 100%; height: 100%; object-fit: cover; border-radius: 3px; pointer-events: none; }
        .aps-remove-btn { position: absolute; top: -8px; right: -8px; background: #d63638; color: #fff; border-radius: 50%; width: 22px; height: 22px; text-align: center; line-height: 20px; cursor: pointer; font-weight: bold; font-size: 16px; border: 2px solid #fff; z-index: 10; }
        .aps-shortcode-box { background: #f0f6fb; padding: 12px; border-left: 4px solid #2271b1; margin-bottom: 20px; }
        .ui-state-highlight { background: #e2eaf2; border: 1px dashed #2271b1; height: 140px; }
    </style>

    <div class="wrap aps-admin-container">
        <h1>DigitalOnion_photo_slider 設定</h1>
        <form method="post">
            <div style="background:#fff; padding:20px; border:1px solid #ccc; border-radius:4px;">
                高さ: <input type="number" name="aps_height" value="<?php echo esc_attr($h); ?>" style="width:80px;"> px
                速度: <input type="number" name="aps_speed" value="<?php echo esc_attr($s_val); ?>" style="width:80px;"> 秒
            </div>

            <ul class="aps-tabs-nav">
                <?php for($s=1; $s<=5; $s++): ?>
                    <li class="aps-tab-link <?php echo $s===1 ? 'active' : ''; ?>" data-tab="tab-<?php echo $s; ?>">スライダー <?php echo $s; ?></li>
                <?php endfor; ?>
            </ul>

            <?php for($s=1; $s<=5; $s++): ?>
                <div id="tab-<?php echo $s; ?>" class="aps-tab-content <?php echo $s===1 ? 'active' : ''; ?>">
                    <div class="aps-shortcode-box">
                        ショートコード: <code>[ainas_slider id="<?php echo $s; ?>"]</code>
                    </div>
                    
                    <button type="button" class="button button-primary add-gallery-btn" data-slider="<?php echo $s; ?>">
                        画像を一括選択して追加
                    </button>
                    
                    <div class="aps-gallery-list sortable" id="gallery_<?php echo $s; ?>">
                        <?php 
                        $imgs = $all_data[$s] ?? [];
                        foreach ($imgs as $url): 
                        ?>
                            <div class="aps-gallery-item">
                                <img src="<?php echo esc_url($url); ?>">
                                <input type="hidden" name="slider_<?php echo $s; ?>_imgs[]" value="<?php echo esc_url($url); ?>">
                                <span class="aps-remove-btn">&times;</span>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endfor; ?>

            <p><input type="submit" name="aps_save" class="button button-primary button-large" value="すべての設定を保存"></p>
        </form>
    </div>

    <script>
    jQuery(document).ready(function($){
        // タブ切り替え
        $('.aps-tab-link').on('click', function(){
            $('.aps-tab-link').removeClass('active');
            $('.aps-tab-content').removeClass('active');
            $(this).addClass('active');
            $("#"+$(this).attr('data-tab')).addClass('active');
        });

        // 並び替え
        $('.sortable').sortable({ placeholder: "ui-state-highlight", forcePlaceholderSize: true });

        // 一括選択アップローダー
        var custom_uploader;
        $('.add-gallery-btn').on('click', function(e){
            e.preventDefault();
            var sliderId = $(this).data('slider');

            // 毎回新しく生成することで選択状態をリセットし、複数選択を確実にする
            custom_uploader = wp.media({
                title: '画像を一括選択',
                library: { type: 'image' },
                button: { text: 'スライダーに追加' },
                multiple: 'add' // 'add' または true を指定
            });

            custom_uploader.on('select', function() {
                var selection = custom_uploader.state().get('selection');
                selection.each(function(attachment) {
                    var url = attachment.attributes.url;
                    var html = '<div class="aps-gallery-item">' +
                        '<img src="' + url + '">' +
                        '<input type="hidden" name="slider_' + sliderId + '_imgs[]" value="' + url + '">' +
                        '<span class="aps-remove-btn">&times;</span>' +
                        '</div>';
                    $('#gallery_' + sliderId).append(html);
                });
            });

            custom_uploader.open();
        });

        // 削除
        $(document).on('click', '.aps-remove-btn', function(){
            $(this).closest('.aps-gallery-item').remove();
        });
    });
    </script>
    <?php
}

/**
 * 4. ショートコードの実装
 */
add_shortcode('ainas_slider', function($atts) {
    $atts = shortcode_atts(['id' => '1'], $atts);
    $slider_id = (int)$atts['id'];
    $h = get_option('aps_height', '300');
    $speed = (float)get_option('aps_speed', '40');
    $all_data = get_option('aps_sliders_data', []);
    $imgs = $all_data[$slider_id] ?? [];

    if (empty($imgs)) return '';
    $unique_id = "aps_" . uniqid();
    $list = array_merge($imgs, $imgs);

    ob_start(); ?>
    <style>
        #<?php echo $unique_id; ?>.aps-wrap { width: 100%; overflow: hidden; position: relative; height: <?php echo $h; ?>px; cursor: grab; }
        #<?php echo $unique_id; ?> .aps-track { display: flex; width: max-content; height: 100%; will-change: transform; }
        #<?php echo $unique_id; ?> .aps-track img { height: <?php echo $h; ?>px; width: auto; pointer-events: none; margin: 0; display: block; }
        @keyframes aps_loop_<?php echo $unique_id; ?> { 0% { transform: translateX(0); } 100% { transform: translateX(-50%); } }
    </style>
    <div class="aps-wrap" id="<?php echo $unique_id; ?>">
        <div class="aps-track" style="animation: aps_loop_<?php echo $unique_id; ?> <?php echo $speed; ?>s linear infinite;">
            <?php foreach ($list as $u): ?><img src="<?php echo esc_url($u); ?>"><?php endforeach; ?>
        </div>
    </div>
    <script>
    (function(){
        const init = function(){
            const wrap = document.getElementById('<?php echo $unique_id; ?>');
            const track = wrap.querySelector('.aps-track');
            if(!track) return;
            let isDown = false, startX, currentX = 0;
            const getX = () => {
                const style = window.getComputedStyle(track);
                const matrix = new (window.WebKitCSSMatrix || window.MSCSSMatrix || DOMMatrix)(style.transform);
                return matrix.m41 || matrix.e || 0;
            };
            const onStart = (e) => {
                isDown = true;
                currentX = getX();
                track.style.animation = 'none';
                track.style.transform = `translateX(${currentX}px)`;
                startX = (e.pageX || (e.touches && e.touches[0].pageX));
                wrap.style.cursor = 'grabbing';
            };
            const onMove = (e) => {
                if(!isDown) return;
                const x = (e.pageX || (e.touches && e.touches[0].pageX));
                let moveX = currentX + (x - startX);
                const half = track.offsetWidth / 2;
                if(moveX > 0) moveX -= half;
                if(moveX < -half) moveX += half;
                track.style.transform = `translateX(${moveX}px)`;
            };
            const onEnd = () => {
                if(!isDown) return;
                isDown = false;
                wrap.style.cursor = 'grab';
                const half = track.offsetWidth / 2;
                let nowX = getX() % half;
                if(nowX > 0) nowX -= half;
                track.style.animation = 'none';
                track.style.transform = 'none';
                void track.offsetWidth; 
                const progress = Math.abs(nowX / half);
                track.style.animation = `aps_loop_<?php echo $unique_id; ?> <?php echo $speed; ?>s linear infinite`;
                track.style.animationDelay = `-${progress * <?php echo $speed; ?>}s`;
            };
            wrap.addEventListener('mousedown', onStart);
            window.addEventListener('mousemove', onMove);
            window.addEventListener('mouseup', onEnd);
            wrap.addEventListener('touchstart', onStart, {passive: true});
            wrap.addEventListener('touchmove', onMove, {passive: true});
            wrap.addEventListener('touchend', onEnd);
        };
        if (document.readyState === 'complete') { init(); } else { window.addEventListener('load', init); }
    })();
    </script>
    <?php return ob_get_clean();
});