<?php
/*
Plugin Name: custom googlemap
Description: ポップアップ高さをさらに30pxアップ。アイキャッチ高さ制限、SNS誘導文言、InfoWindow単一表示＆全体リンク。1カラム廃止版。
Version: 31.0
Author: Awaji_Tamao
*/

if (!defined('ABSPATH')) exit;

// 1. カスタム投稿
add_action('init', function() {
    register_post_type('shop', [
        'labels' => ['name' => '店舗情報', 'singular_name' => '店舗'],
        'public' => true, 'has_archive' => true, 'menu_icon' => 'dashicons-location',
        'supports' => ['title', 'editor', 'thumbnail'], 'show_in_rest' => true,
    ]);
});

// 2. メディアアップローダー
add_action('admin_enqueue_scripts', function() {
    if (get_post_type() === 'shop' || (isset($_GET['page']) && $_GET['page'] === 'cstm_map_settings')) {
        wp_enqueue_media();
    }
});

add_action('admin_footer', function() {
    if ((isset($_GET['page']) && $_GET['page'] === 'cstm_map_settings') || get_post_type() === 'shop') :
    ?>
    <script>
    jQuery(document).ready(function($){
        $(document).on('click', '.cstm-upload-btn', function(e) {
            e.preventDefault();
            var btn = $(this), input = btn.closest('td, div').find('.cstm-url-input'), previewWrap = btn.closest('td, div').find('.cstm-preview-wrap');
            var frame = wp.media({title:'画像選択', button:{text:'使用する'}, multiple:false});
            frame.on('select', function(){
                var attachment = frame.state().get('selection').first().toJSON();
                input.val(attachment.url);
                previewWrap.html('<img src="'+attachment.url+'" style="max-width:100px; max-height:100px; display:block; margin-top:5px; border:1px solid #ccc;">');
            });
            frame.open();
        });
        $(document).on('click', '.cstm-delete-btn', function(e) {
            e.preventDefault();
            if(!confirm('解除しますか？')) return;
            $(this).closest('td, div').find('.cstm-url-input').val('');
            $(this).closest('td, div').find('.cstm-preview-wrap').empty();
        });
    });
    </script>
    <?php
    endif;
});

// 3. メタボックス
add_action('add_meta_boxes', function() {
    add_meta_box('shop_details', '詳細・SNS設定', 'cstm_fields_html', 'shop', 'side');
});
function cstm_fields_html($post) {
    wp_nonce_field('c_act', 'c_nonce');
    $fields = ['_shop_coords'=>'座標(lat,lng)','_shop_zip'=>'郵便番号','_shop_addr'=>'住所','_shop_hours'=>'営業時間','_shop_img2'=>'追加画像1','_shop_img3'=>'追加画像2','_shop_x'=>'X URL','_shop_insta'=>'Instagram URL','_shop_tiktok'=>'TikTok URL'];
    foreach($fields as $k => $l) {
        $v = get_post_meta($post->ID, $k, true);
        echo '<div style="margin-bottom:15px; padding-bottom:10px; border-bottom:1px solid #eee;"><label style="font-weight:bold;">'.esc_html($l).'</label><br>';
        echo '<input type="text" name="'.esc_attr($k).'" value="'.esc_attr($v).'" class="cstm-url-input" style="width:100%;">';
        if(strpos($k, 'img') !== false) {
            echo '<div class="cstm-preview-wrap" style="margin-top:5px;">' . ($v ? '<img src="'.esc_url($v).'" style="max-width:100px; max-height:100px; border:1px solid #ccc;">' : '') . '</div>';
            echo '<button type="button" class="button cstm-upload-btn" style="margin-top:5px;">選択</button> <button type="button" class="button cstm-delete-btn" style="margin-top:5px; color:#a00;">削除</button>';
        }
        echo '</div>';
    }
}
add_action('save_post', function($id) {
    if (!isset($_POST['c_nonce']) || !wp_verify_nonce($_POST['c_nonce'], 'c_act')) return;
    foreach(['_shop_coords','_shop_zip','_shop_addr','_shop_hours','_shop_img2','_shop_img3','_shop_x','_shop_insta','_shop_tiktok'] as $k) {
        if(isset($_POST[$k])) update_post_meta($id, $k, sanitize_text_field($_POST[$k]));
    }
});

// 4. 設定画面
add_action('admin_menu', function(){
    add_menu_page('Custom GoogleMap 設定', 'Custom GoogleMap', 'manage_options', 'cstm_map_settings', 'cstm_set_page', 'dashicons-location-alt', 25);
});

function cstm_set_page() {
    if(isset($_POST['save'])){
        foreach(['api','pin','pc_map_only','sp_map_only','pc_with_cards','sp_with_cards','jump_url','icon_x','icon_insta','icon_tiktok'] as $v) update_option('c_'.$v, $_POST[$v] ?? '');
        echo '<div class="updated"><p>保存しました。</p></div>';
    }
    ?>
    <div class="wrap">
        <h1>Custom GoogleMap 共通設定</h1>
        <div style="display: flex; gap: 30px; align-items: flex-start;">
            <div style="flex: 1;">
                <form method="post"><table class="form-table">
                    <tr><th>API Key</th><td><input type="text" name="api" value="<?php echo esc_attr(get_option('c_api')); ?>" class="regular-text"></td></tr>
                    <?php 
                    $img_settings = ['pin'=>'共通ピン','icon_x'=>'Xアイコン','icon_insta'=>'Instaアイコン','icon_tiktok'=>'TikTokアイコン'];
                    foreach($img_settings as $key => $label): 
                        $val = get_option('c_'.$key);
                    ?>
                    <tr><th><?php echo esc_html($label); ?></th><td>
                        <input type="text" name="<?php echo $key; ?>" value="<?php echo esc_attr($val); ?>" class="cstm-url-input regular-text">
                        <div class="cstm-preview-wrap" style="margin-top:5px;"><?php if($val): ?><img src="<?php echo esc_url($val); ?>" style="max-width:100px; max-height:100px; border:1px solid #ccc;"><?php endif; ?></div>
                        <button type="button" class="button cstm-upload-btn">選択</button> <button type="button" class="button cstm-delete-btn" style="color:#a00;">削除</button>
                    </td></tr>
                    <?php endforeach; ?>
                    <tr><th>高さ：マップのみ</th><td>PC:<input type="number" name="pc_map_only" value="<?php echo esc_attr(get_option('c_pc_map_only','600')); ?>">px / SP:<input type="number" name="sp_map_only" value="<?php echo esc_attr(get_option('c_sp_map_only','400')); ?>">px</td></tr>
                    <tr><th>高さ：カードあり</th><td>PC:<input type="number" name="pc_with_cards" value="<?php echo esc_attr(get_option('c_pc_with_cards','500')); ?>">px / SP:<input type="number" name="sp_with_cards" value="<?php echo esc_attr(get_option('c_sp_with_cards','350')); ?>">px</td></tr>
                    <tr><th>ジャンプ先URL</th><td><input type="text" name="jump_url" value="<?php echo esc_attr(get_option('c_jump_url')); ?>" class="regular-text"></td></tr>
                </table><input type="submit" name="save" class="button button-primary" value="保存"></form>
            </div>

            <div style="width: 300px; background: #fff; padding: 20px; border: 1px solid #ccd0d4; border-radius: 4px;">
                <h2 style="margin-top:0; font-size:1.1em; border-bottom:1px solid #eee; padding-bottom:10px;">ショートコードの使い方</h2>
                <p>固定ページや投稿に以下のコードを貼り付けてください。</p>
                <div style="margin-bottom:20px;">
                    <label style="font-weight:bold; display:block; margin-bottom:5px;">● マップのみ表示</label>
                    <code style="display:block; background:#f0f0f1; padding:10px; border-radius:3px;">[cstm_map]</code>
                </div>
                <div>
                    <label style="font-weight:bold; display:block; margin-bottom:5px;">● マップ ＋ 店舗カード表示</label>
                    <code style="display:block; background:#f0f0f1; padding:10px; border-radius:3px;">[cstm_map_full]</code>
                </div>
            </div>
        </div>
    </div>
    <?php
}

// 5. フロントエンド描画
function render_cstm_map_logic($show_cards = false) {
    $api = get_option('c_api'); if(!$api) return 'APIキーを設定してください。';
    
    $h_pc = $show_cards ? get_option('c_pc_with_cards','500') : get_option('c_pc_map_only','600');
    $h_sp = $show_cards ? get_option('c_sp_with_cards','350') : get_option('c_sp_map_only','400');

    $prefs = ["北海道","青森県","岩手県","宮城県","秋田県","山形県","福島県","茨城県","栃木県","群馬県","埼玉県","千葉県","東京都","神奈川県","新潟県","富山県","石川県","福井県","山梨県","長野県","岐阜県","静岡県","愛知県","三重県","滋賀県","京都府","大阪府","兵庫県","奈良県","和歌山県","鳥取県","島根県","岡山県","広島県","山口県","徳島県","香川県","愛媛県","高知県","福岡県","佐賀県","長崎県","熊本県","大分県","宮崎県","鹿児島県","沖縄県"];
    
    $shops = get_posts(['post_type'=>'shop', 'posts_per_page'=>-1]);
    $locs = [];
    $grouped_shops = [];

    foreach($shops as $s) {
        $coords = get_post_meta($s->ID,'_shop_coords',true);
        if(!$coords) continue;
        $ll = explode(',',$coords);
        $addr = get_post_meta($s->ID,'_shop_addr',true);
        $target_pref = "";
        foreach($prefs as $p) { if(strpos($addr, $p) === 0){ $target_pref = $p; break; } }
        
        $data = [
            'id' => $s->ID, 'lat' => (float)$ll[0], 'lng' => (float)$ll[1], 'title' => $s->post_title,
            'zip' => get_post_meta($s->ID,'_shop_zip',true), 'addr' => $addr, 'hours' => get_post_meta($s->ID,'_shop_hours',true),
            'thumb' => get_the_post_thumbnail_url($s->ID,'large'), 'img2' => get_post_meta($s->ID,'_shop_img2',true), 'img3' => get_post_meta($s->ID,'_shop_img3',true),
            'text' => apply_filters('the_content', $s->post_content),
            'excerpt' => wp_trim_words(strip_tags($s->post_content), 30, '...'),
            'sns' => ['x' => get_post_meta($s->ID, '_shop_x', true), 'insta' => get_post_meta($s->ID, '_shop_insta', true), 'tiktok' => get_post_meta($s->ID, '_shop_tiktok', true)],
            'pref' => $target_pref
        ];
        $locs[] = $data;
        if($target_pref) $grouped_shops[$target_pref][] = $data;
    }

    ob_start(); ?>
    <style>
        #cstm-map { width:100%; height:<?php echo $h_pc; ?>px; border-radius:12px; margin-bottom:30px; position: relative; z-index: 1; }
        @media(max-width:768px){ #cstm-map { height:<?php echo $h_sp; ?>px; } }
        .pref-nav-wrap { text-align: center; margin-bottom: 30px; }
        .pref-nav { padding: 10px 20px; border-radius: 25px; border: 1px solid #ddd; font-size: 16px; min-width: 200px; }
        .pref-block { margin-bottom: 50px; }
        .pref-title { font-size: 24px; font-weight: bold; border-left: 5px solid #e62e2e; padding-left: 15px; margin-bottom: 20px; }
        .shop-grid { display: grid; gap: 20px; width: 100%; grid-template-columns: repeat(3, 1fr); }
        @media(max-width:992px){ .shop-grid { grid-template-columns: repeat(2, 1fr); } }
        @media(max-width:600px){ .shop-grid { grid-template-columns: 1fr; } }
        .shop-card { background:#fff; border:1px solid #eee; border-radius:12px; overflow:hidden; display:flex; flex-direction:column; box-shadow:0 4px 10px rgba(0,0,0,0.1); cursor: pointer; transition: transform 0.2s; }
        .shop-card:hover { transform: translateY(-5px); }
        .card-eyecatch { width:100%; height:200px; object-fit:cover; flex-shrink:0; }
        .shop-card-body { padding:15px; flex-grow:1; display:flex; flex-direction:column; gap:10px; } 
        .shop-card-title { font-size:1.2em; font-weight:bold; margin:0; }
        .shop-card-excerpt { font-size:14px; color:#666; line-height:1.5; }

        .cstm-modal-overlay { position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.85); display:none; z-index:2000000000 !important; }
        .modal-content { 
            background:#fff; width:90%; max-width:900px; position: fixed !important; 
            top: 120px !important; left: 50% !important; transform: translateX(-50%) !important;
            max-height: calc(95vh - 130px); border-radius:12px; overflow:hidden; display: flex; flex-direction: column; box-shadow: 0 10px 40px rgba(0,0,0,0.5); z-index: 2000000001 !important;
        }
        @media(max-width:768px){ .modal-content { top: 70px !important; max-height: calc(95vh - 80px); } }

        .modal-header-bar { background: #e62e2e; color: #fff; padding: 12px 20px; display: flex; justify-content: space-between; align-items: center; flex-shrink: 0; }
        .modal-header-title { font-weight: bold; font-size: 1.1em; margin: 0; }
        .modal-close { font-size: 28px; cursor: pointer; line-height: 1; }
        .modal-scroll-area { padding: 25px; overflow-y: auto; }
        
        .modal-main-eyecatch { width: 100%; height: 250px; object-fit: cover; border-radius: 8px; margin-bottom: 20px; cursor: zoom-in; }
        @media(max-width:768px){ .modal-main-eyecatch { height: 180px; } }
        .modal-gallery { display: flex; gap: 10px; margin-bottom: 25px; }
        .modal-gallery img { width: calc(50% - 5px); height: 180px; object-fit: cover; cursor: zoom-in; border-radius: 8px; }
        .modal-info-box { background: #f8f8f8; padding: 20px; border-radius: 10px; margin-top: 25px; font-size: 14px; line-height: 1.8; }
        .modal-sns-notice { color: #e62e2e; font-weight: bold; text-align: center; margin-bottom: 10px; font-size: 15px; }
        .modal-sns { display: flex; gap: 15px; margin: 0 0 25px 0; justify-content: center; }
        .modal-sns img { width: 45px; height: 45px; transition: 0.2s; cursor: pointer; }
        .modal-btn-map { display: block; background: #4285f4; color: #fff !important; text-decoration: none !important; text-align: center; padding: 15px; border-radius: 8px; font-weight: bold; margin-top: 20px; }

        #cstm-img-zoom-modal { display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.95); z-index: 2147483647 !important; cursor: zoom-out; align-items: center; justify-content: center; }
        #cstm-img-zoom-modal img { width: 900px; height: 600px; object-fit: cover; border-radius: 8px; }
        @media(max-width:920px){ #cstm-img-zoom-modal img { width: 95%; height: auto; max-height: 90vh; object-fit: contain; } }

        .gm-style-iw { padding: 0 !important; cursor: pointer; }
        .gm-style-iw-d { overflow: hidden !important; }
        .cstm-iw-container { padding: 10px; width: 200px; }
    </style>

    <div id="cstm-map"></div>

    <?php if($show_cards && !empty($grouped_shops)): ?>
    <div class="pref-nav-wrap">
        <select class="pref-nav" id="pref-selector">
            <option value="">都道府県を選択</option>
            <?php foreach($prefs as $p) if(isset($grouped_shops[$p])): ?>
                <option value="pref-<?php echo $p; ?>"><?php echo $p; ?></option>
            <?php endif; ?>
        </select>
    </div>

    <div class="shop-container">
        <?php foreach($prefs as $p): if(!isset($grouped_shops[$p])) continue; ?>
        <div class="pref-block" id="pref-<?php echo $p; ?>">
            <div class="pref-title"><?php echo $p; ?></div>
            <div class="shop-grid">
                <?php foreach($grouped_shops[$p] as $l): ?>
                <div class="shop-card" onclick='openCstmModal(<?php echo json_encode($l); ?>)'>
                    <?php if($l['thumb']): ?><img src="<?php echo esc_url($l['thumb']); ?>" class="card-eyecatch" loading="lazy"><?php endif; ?>
                    <div class="shop-card-body">
                        <div class="shop-card-title"><?php echo esc_html($l['title']); ?></div>
                        <div class="shop-card-excerpt"><?php echo esc_html($l['excerpt']); ?></div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>

    <div id="cstm-modal" class="cstm-modal-overlay">
        <div class="modal-content">
            <div class="modal-header-bar"><div id="modal-title-pref" class="modal-header-title"></div><div class="modal-close" onclick="closeCstmModal()">×</div></div>
            <div class="modal-scroll-area" id="modal-inner-content"></div>
        </div>
    </div>
    <div id="cstm-img-zoom-modal" onclick="this.style.display='none'"><img src="" id="zoomed-img"></div>

    <script>
        var mapLocs = <?php echo json_encode($locs); ?>;
        var snsIcons = { x: "<?php echo get_option('c_icon_x'); ?>", insta: "<?php echo get_option('c_icon_insta'); ?>", tiktok: "<?php echo get_option('c_icon_tiktok'); ?>" };
        var currentInfoWindow = null;

        document.getElementById('pref-selector')?.addEventListener('change', function() {
            const id = this.value; if(!id) return;
            const el = document.getElementById(id);
            if(el) {
                const rect = el.getBoundingClientRect();
                const offset = rect.top + window.pageYOffset - 120;
                window.scrollTo({top: offset, behavior: 'smooth'});
            }
        });

        function openCstmModal(d) {
            document.getElementById('modal-title-pref').innerText = (d.pref ? '【' + d.pref + '】 ' : '') + d.title;
            let h = '';
            if(d.thumb) h += '<img src="'+d.thumb+'" class="modal-main-eyecatch" onclick="zoomImg(this.src)">';
            if(d.img2 || d.img3){
                h += '<div class="modal-gallery">';
                if(d.img2) h += '<img src="'+d.img2+'" onclick="zoomImg(this.src)">';
                if(d.img3) h += '<img src="'+d.img3+'" onclick="zoomImg(this.src)">';
                h += '</div>';
            }
            h += '<div class="modal-main-text">' + d.text + '</div>';
            h += '<div class="modal-info-box">';
            if(d.zip) h += '<div><strong>郵便番号</strong>： 〒' + d.zip + '</div>';
            if(d.addr) h += '<div><strong>住所</strong>： ' + d.addr + '</div>';
            if(d.hours) h += '<div><strong>営業時間</strong>： ' + d.hours + '</div>';
            h += '</div>';

            if(d.sns.x || d.sns.insta || d.sns.tiktok){
                h += '<div class="modal-sns-notice">詳しい商品情報は各SNSからチェックしてください！</div>';
                h += '<div class="modal-sns">';
                if(d.sns.x && snsIcons.x) h += '<a href="'+d.sns.x+'" target="_blank"><img src="'+snsIcons.x+'"></a>';
                if(d.sns.insta && snsIcons.insta) h += '<a href="'+d.sns.insta+'" target="_blank"><img src="'+snsIcons.insta+'"></a>';
                if(d.sns.tiktok && snsIcons.tiktok) h += '<a href="'+d.sns.tiktok+'" target="_blank"><img src="'+snsIcons.tiktok+'"></a>';
                h += '</div>';
            }
            h += '<a href="https://www.google.com/maps/search/?api=1&query=' + encodeURIComponent(d.addr + ' ' + d.title) + '" target="_blank" class="modal-btn-map">Googleマップで開く</a>';
            document.getElementById('modal-inner-content').innerHTML = h;
            document.querySelectorAll('#modal-inner-content img').forEach(img => { img.onclick = function() { zoomImg(this.src); }; });
            document.getElementById('cstm-modal').style.display = 'block';
            document.body.style.overflow = 'hidden';
            document.querySelector('.modal-scroll-area').scrollTop = 0;
        }

        function zoomImg(src) {
            document.getElementById('zoomed-img').src = src;
            document.getElementById('cstm-img-zoom-modal').style.display = 'flex';
        }

        function closeCstmModal() { document.getElementById('cstm-modal').style.display = 'none'; document.body.style.overflow = ''; }
        window.onclick = function(e) { if (e.target == document.getElementById('cstm-modal')) closeCstmModal(); }

        function initMap() {
            var map = new google.maps.Map(document.getElementById('cstm-map'), { zoom: 14 });
            var b = new google.maps.LatLngBounds();
            var pin = "<?php echo get_option('c_pin'); ?>";

            mapLocs.forEach(function(d) {
                var m = new google.maps.Marker({ position: { lat: d.lat, lng: d.lng }, map: map, icon: pin ? { url: pin, scaledSize: new google.maps.Size(40, 40) } : null });
                var infoHtml = '<div class="cstm-iw-container" onclick=\'openCstmModal('+JSON.stringify(d)+')\'>';
                if(d.thumb) infoHtml += '<img src="'+d.thumb+'" style="width:100%; height:auto; border-radius:4px; margin-bottom:5px;">';
                infoHtml += '<strong>'+d.title+'</strong><br><span style="color:#4285f4;font-size:12px;font-weight:bold;display:inline-block;margin-top:5px;">詳細をみる</span></div>';
                var iw = new google.maps.InfoWindow({ content: infoHtml });
                m.addListener('click', function() {
                    if (currentInfoWindow) currentInfoWindow.close();
                    iw.open(map, m);
                    currentInfoWindow = iw;
                });
                b.extend(m.position);
            });
            if (mapLocs.length > 0) map.fitBounds(b);
        }
    </script>
    <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo $api; ?>&callback=initMap" async defer></script>
    <?php return ob_get_clean();
}
add_shortcode('cstm_map', function() { return render_cstm_map_logic(false); });
add_shortcode('cstm_map_full', function() { return render_cstm_map_logic(true); });